extends Node2D
class_name Piece

@export var color : String
@export var square_face : Texture

var matched := false
var point := 0

@onready var sprite = $Sprite
@onready var spawn_sound = $SpawnSound
@onready var match_sound = $MatchSound

func _ready():
	spawn_sound.play()

func move(target):
	var tween = get_tree().create_tween()
	tween.tween_property(self, "position", target, .5).set_trans(Tween.TRANS_ELASTIC).set_ease(Tween.EASE_OUT)

func make_matched():
	matched = true
#	sprite.modulate = Color(1,1,1,.5)
	sprite.texture = square_face
	match_sound.play()
