extends Node2D

const UNIT := 32
const OFFSET := UNIT / 2.0
const SCREEN_WIDTH = 1152
const SCREEN_HEIGHT = 648
const WIDTH := SCREEN_WIDTH / UNIT - 1
const HEIGHT := SCREEN_HEIGHT / UNIT - 1

@onready var snake: Node2D = $Snake
@onready var snake_food: Sprite2D = $Food
@onready var snake_score: Label = $Label
@onready var start_screen: Control = $StartScreen

func _input(event) -> void:
	if not snake.active and event is InputEventKey:
		restart_game()

func _process(_delta: float) -> void:
	if is_zero_approx(snake.snake_head.position.x - snake_food.position.x) and is_zero_approx(snake.snake_head.position.y - snake_food.position.y):
		snake.grow()

		move_random()
		while snake.is_collided(snake_food.position):
			move_random()

func move_random() -> void:
	var x = (floor(randf_range(0, WIDTH)) * UNIT + OFFSET) as int
	var y = (floor(randf_range(0, HEIGHT)) * UNIT + OFFSET) as int

	snake_food.position = Vector2(x, y)

func restart_game():
	snake.restart()
	$StartScreen.set_visible(false)

func terminate_game():
	snake.active = false
	$StartScreen.set_visible(true)

func _on_snake_snake_grow(body_parts: Array) -> void:
	if snake_score:
		snake_score.set_text("Score: %d" % (body_parts.size() - 1))

func _on_snake_snake_terminate() -> void:
	terminate_game()
